package cn.ninegame.ad.demo.activity;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.widget.Button;

import cn.ninegame.ad.demo.R;
import cn.ninegame.ad.demo.config.NGAdManagerHolder;
import cn.sirius.nga.NGAdSdk;

public class StartActivity extends Activity {
    private Button mBtnInit;
    private Button mBtnStart;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_start);
        mBtnInit = findViewById(R.id.btn_init);
        mBtnStart = findViewById(R.id.btn_start);

        if (NGAdSdk.isSdkReady()) {
            NGAdManagerHolder.startActivity(this);
        }

        findViewById(R.id.btn_privacy_config).setOnClickListener(v -> {
            // 自定义合规隐私配置，非必须，不配置则采用默认配置
            final Intent intent = new Intent(this, PrivacyConfigActivity.class);
            startActivity(intent);
        });

        mBtnInit.setOnClickListener(v -> {
            //调用初始化
            /** 这里要传入 Activity，部分ADN平台要求*/
            NGAdManagerHolder.init(StartActivity.this);
        });
        mBtnStart.setOnClickListener(v -> {
            //开始展示广告
            NGAdManagerHolder.start(StartActivity.this);
        });
    }
}
